const OLLAMA_URL = 'http://localhost:11434/api/generate';

export interface ExtractedInvoiceData {
  invoiceNumber: string;
  invoiceDate: string;
  supplierName: string;
  supplierOrderNumber?: string;
  customerPoNumber?: string;
  items: {
    productCode: string;
    description: string;
    quantity: number;
    unitPrice: number;
  }[];
}

export async function extractInvoiceData(text: string): Promise<ExtractedInvoiceData> {
  try {
    const prompt = `
      Extract the following information from this invoice text. Return ONLY valid JSON:
      - Invoice number
      - Invoice date (in YYYY-MM-DD format)
      - Supplier name
      - Supplier order number (if present)
      - Customer PO number (if present)
      - Line items with:
        - Product code
        - Description
        - Quantity (as number)
        - Unit price (as number)
      
      Invoice text:
      ${text}
    `;

    const response = await fetch(OLLAMA_URL, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        model: 'gemma',
        prompt,
        stream: false,
      }),
    });

    if (!response.ok) {
      throw new Error('Failed to extract invoice data');
    }

    const data = await response.json();
    return JSON.parse(data.response);
  } catch (error) {
    console.error('Error extracting invoice data:', error);
    throw new Error('Failed to process invoice. Please try again or enter data manually.');
  }
}